﻿DROP PROCEDURE [hips].[PcehrMessageQueueGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date:   3 March 2013
-- Description:   Gets a specified record from the PcehrMessageQueue Table
-- Modified:
-- 15/09/2013 added SourceSystemSetId & SourceSystemDocumentId
-- =============================================
CREATE PROCEDURE [hips].[PcehrMessageQueueGet] 
(
	    @EpisodeId INT = NULL
	   ,@PcehrMessageQueueId INT = NULL
) AS
BEGIN
SELECT  pmq.PcehrMessageQueueId,
		pmq.QueueOperationId,
		pmq.QueueStatusId,
		qs.Description as QueueStatusDescription,
		qo.Description as QueueOperationName,
		pmq.EpisodeId,
		pmq.SerialisedObject,
		pmq.SourceSystemSetId,
		pmq.SourceSystemDocumentId,
		pmq.Request,
		pmq.Response,
		pmq.Details,
		pmq.DateCreated,
		pmq.UserCreated,
		pmq.DateModified,
		pmq.UserModified
FROM  hips.PcehrMessageQueue As pmq
INNER JOIN hips.QueueStatus As qs on qs.QueueStatusId = pmq.QueueStatusId
INNER JOIN hips.QueueOperation AS qo ON qo.QueueOperationId = pmq.QueueOperationId
WHERE (EpisodeId = @EpisodeId OR @EpisodeId IS NULL)
AND (PcehrMessageQueueId = @PcehrMessageQueueId OR @PcehrMessageQueueId IS NULL)

END
GO
